
!"Pocket Smalltalk fileout - Monday, May 21, 2001-12:55:57 AM"!


!Object constantsFor: 'Resource Databases'!

resourceDB1 '*.bin'! 
resourceDB2 '..\vm16a4.prc'! !

!Object constantsFor: 'System Properties'!

applicationTitle 'PST Demo'! 
callStackSize 100! 
creatorID 'STdm'! 
dataStackSize 300! 
debug false! 
heapSize 2000! 
objectTableSize 800! 
optimization true! !

Application subclass: #ButtonTest
	instanceVariableNames: 'buttonModel repeatTextModel popupListModel'
	classVariableNames: ''!

Application subclass: #DatabaseTest
	instanceVariableNames: 'textModel'
	classVariableNames: ''!

Application subclass: #DateTest
	instanceVariableNames: 'currentDateModel dateStringModel timeStringModel dateFormatsModel formatStringModel'
	classVariableNames: ''!

Application subclass: #ListboxTest
	instanceVariableNames: 'listModel selectionTextModel textModel'
	classVariableNames: ''!

Application subclass: #ScrollbarTest
	instanceVariableNames: 'scrollModel'
	classVariableNames: ''!

Application subclass: #TestLauncher
	instanceVariableNames: ''
	classVariableNames: ''!

!ButtonTest methodsFor: 'initialization'!

initialize

	super initialize.

	buttonModel := ValueHolder with: false.

	repeatTextModel := ValueHolder with: 0.

	popupListModel := ListModel list: #('Apple' 'Banana' 'Cherry').!

createComponents

	self add: PushButton id: 3000 name: nil aspect: #buttonModel.

	self add: Checkbox id: 3001 name: nil aspect: #buttonModel.

	self add: RepeatButton id: 3002 name: nil aspect: #repeatButton.

	self add: TextField id: 3003 name: nil aspect: #repeatTextModel.

	self add: Button id: 3005 name: nil aspect: #normalButton.

	self add: Listbox id: 3020 name: nil aspect: #popupListModel.

	self add: PopupTrigger id: 3021 name: nil aspect: nil.

	self add: SelectorTrigger id: 3023 name: nil aspect: #hitSelectorTrigger.

	self add: Button id: 3050 name: nil aspect: #done.! !


!ButtonTest methodsFor: 'aspects'!

buttonModel

	^buttonModel.!

repeatTextModel

	^repeatTextModel.!

popupListModel

	^popupListModel.! !


!ButtonTest methodsFor: 'actions'!

repeatButton

	repeatTextModel value: repeatTextModel value + 1.!

normalButton

	Form notify: 'You clicked me!!'.!

hitSelectorTrigger

	Form notify: 'Hit selector trigger!!'.!

done

	self spawn: TestLauncher new.! !


!ButtonTest class methodsFor: 'accessing'!

formID

	^3005.! !


!DatabaseTest methodsFor: 'widget accessor'!

text
	"Widget accessor for Field (3000) [text] {textModel}."
	^self widgetNamed: #text! !


!DatabaseTest methodsFor: 'initialization'!

createComponents

	self add: TextField id: 3000 name: #text aspect: #textModel.

	self add: Button id: 3001 name: nil aspect: #addMemo.

	self add: Button id: 3002 name: nil aspect: #done.!

initialize

	super initialize.

	textModel := ValueHolder with: ''.! !


!DatabaseTest methodsFor: 'aspects'!

textModel

	^textModel.! !


!DatabaseTest methodsFor: 'actions'!

done

	self spawn: TestLauncher new.!

addMemo

	| database |

	(self widgetNamed: #text) updateModel.

	textModel value isEmpty 

		ifTrue: [^Form notify: 'Enter some text first.'].

	database := Database

		open: 'MemoDB'

		mode: ##dmModeReadWrite.

	database appendRecord: textModel value, 

		(String with: 0 asCharacter).

	Form notify: 'Memo added.  There are now ',

		database recordCount printString, ' memos.'.

	database close.! !


!DatabaseTest class methodsFor: 'accessing'!

formID

	^3002.! !


!DateTest methodsFor: 'initialization'!

createComponents

	self add: TextField id: 3001 name: nil aspect: #currentDateModel.

	self add: Button id: 3002 name: nil aspect: #selectTime.

	self add: TextField id: 3003 name: nil aspect: #timeStringModel.

	self add: Button id: 3004 name: nil aspect: #selectDate.

	self add: TextField id: 3005 name: nil aspect: #dateStringModel.

	self add: Listbox id: 3007 name: nil aspect: #dateFormatsModel.

	self add: Button id: 3008 name: nil aspect: #done.

	self add: TextField id: 3009 name: nil aspect: #formatStringModel.

!

initialize

	super initialize.

	currentDateModel := ValueHolder with: ''.

	dateStringModel := ValueHolder with: ''.

	timeStringModel := ValueHolder with: ''.

	dateFormatsModel := ListModel list: #('MDY w/ slashes' 'DMY w/ slashes' 'DMY w/ dots' 'DMY w/ dashes' 'YMD w/ slashes' 'YMD w/ dots' 'YMD w/ dashes' 'MDY long w/ comma' 'DMY long' 'DMY long w/ dot' 'DMY long, no day' 'DMY long w/ comma' 'YMD long w/ dot' 'YMD long w/ space' 'MY short form').

	dateFormatsModel addDependent: self.

	formatStringModel := ValueHolder with: ''.! !


!DateTest methodsFor: 'aspects'!

currentDateModel

	^currentDateModel.!

dateStringModel

	^dateStringModel.!

timeStringModel

	^timeStringModel.!

dateFormatsModel

	^dateFormatsModel.!

formatStringModel

	^formatStringModel.! !


!DateTest methodsFor: 'event handling'!

eventTimeout

	^100.  "once per second"!

handleNilEvent

	self updateCurrentDate.

	^super handleNilEvent.!

onOpened

	self updateCurrentDate.! !


!DateTest methodsFor: 'updating'!

updateCurrentDate

	currentDateModel ifNotNil: [

		currentDateModel value: DateAndTime now printString].!

update: aspect with: parameter from: object

	(object == dateFormatsModel and: [aspect == #selection])

		ifTrue: [self updateFormattedDate].!

updateFormattedDate

	| format |

	format := dateFormatsModel selectionIndex.

	format = 0 ifTrue: [^self].

	formatStringModel value: (Date now printString: format - 1).! !


!DateTest methodsFor: 'actions'!

selectTime

	| range |

	range := Time

		selectTimeRangeFrom: Time now

		to: Time now

		untimed: false

		startingHour: 3

		caption: 'Select a Time'.

	range == #untimed ifTrue: [^timeStringModel value: 'Untimed'].

	range isNil ifTrue: [^timeStringModel value: 'No time selected'].

	^timeStringModel value: (range at: 1) printString, 

			' to: ', (range at: 2) printString.!

selectDate

	| date |

	date := Date selectDate.

	dateStringModel value: (date isNil

		ifTrue: ['No date selected']

		ifFalse: [date printString]).!

done

	self spawn: TestLauncher new.! !


!DateTest class methodsFor: 'accessing'!

formID

	^3004.! !


!ListboxTest methodsFor: 'dependents'!

update: aspect with: parameter from: object

	object == listModel ifTrue: [

		aspect == #selection

			ifTrue: [self updateSelectionText]].! !


!ListboxTest methodsFor: 'widget accessor'!

text
	"Widget accessor for Field (3006) [text] {textModel}."
	^self widgetNamed: #text! !


!ListboxTest methodsFor: 'initialization'!

initialize

	super initialize.

	listModel := ListModel list: #('First list item' 'Second list item' 'Third list item').

	listModel addDependent: self.

	selectionTextModel := ValueHolder with: ''.

	textModel := ValueHolder with: ''.!

createComponents

	self add: Listbox id: 3002 name: nil aspect: #listModel.

	self add: TextField id: 3004 name: nil aspect: #selectionTextModel.

	self add: Button id: 3005 name: nil aspect: #addItem.

	self add: TextField id: 3006 name: #text aspect: #textModel.

	self add: Button id: 3007 name: nil aspect: #deleteSelectedItem.

	self add: Button id: 3008 name: nil aspect: #done.! !


!ListboxTest methodsFor: 'aspects'!

listModel

	^listModel.!

textModel

	^textModel.!

selectionTextModel

	^selectionTextModel.! !


!ListboxTest methodsFor: 'actions'!

deleteSelectedItem

	| list index |

	list := listModel list asList.

	index := listModel selectionIndex.

	(list includesKey: index) ifFalse: [^Form notify: 'No item is selected.'].

	list removeAtIndex: index.

	listModel list: list.!

done

	self spawn: TestLauncher new.!

addItem

	| list |

	list := listModel list asList.

	(self widgetNamed: #text) updateModel.

	list add: textModel value copy.

	listModel list: list.! !


!ListboxTest methodsFor: 'updating'!

updateSelectionText

	selectionTextModel value: listModel selectionIndex printString.! !


!ListboxTest methodsFor: 'events'!

onOpened

	self updateSelectionText.! !


!ListboxTest class methodsFor: 'accessing'!

formID

	^3003.! !


!ScrollbarTest methodsFor: 'widget accessor'!

text
	"Widget accessor for Field (3001) [text] {scrollModel}."
	^self widgetNamed: #text! !


!ScrollbarTest methodsFor: 'initialization'!

initialize

	super initialize.

	scrollModel := ScrollValueHolder with: 25.

	scrollModel

		min: 1;

		max: 50;

		pageSize: 10.!

createComponents

	self add: Scrollbar id: 3000 name: nil aspect: #scrollModel.

	self add: Scrollbar id: 3004 name: nil aspect: #scrollModel.

	self add: TextField id: 3001 name: #text aspect: #scrollModel.

	self add: Button id: 3002 name: nil aspect: #accept.

	self add: Button id: 3003 name: nil aspect: #done.

	self add: Button id: 3007 name: nil aspect: #increment.

	self add: Button id: 3008 name: nil aspect: #decrement.! !


!ScrollbarTest methodsFor: 'aspects'!

scrollModel

	^scrollModel.! !


!ScrollbarTest methodsFor: 'actions'!

done

	self spawn: TestLauncher new.!

increment

	scrollModel value: scrollModel value + 1.!

decrement

	scrollModel value: scrollModel value - 1.!

accept

	(self widgetNamed: #text) updateModel.! !


!ScrollbarTest class methodsFor: 'uncategorized'!

formID

	^3001.! !


!TestLauncher methodsFor: 'initialization'!

createComponents

	self add: Button id: 3000 name: nil aspect: #scrollbarTest.

	self add: Button id: 3001 name: nil aspect: #databaseTest.

	self add: Button id: 3002 name: nil aspect: #listboxTest.

	self add: Button id: 3003 name: nil aspect: #dateTest.

	self add: Button id: 3004 name: nil aspect: #buttonTest.

	self add: Button id: 3020 name: nil aspect: #done.

	self add: Button id: 3021 name: nil aspect: #showFreeMemory.!

createMenus
	"Forms with menus should override this to create the menu actions (using #addMenuAction:forID:)."
	^self addMenuAction: #about forID: 3000.! !


!TestLauncher methodsFor: 'actions'!

scrollbarTest

	self spawn: ScrollbarTest new.!

databaseTest

	self spawn: DatabaseTest new.!

listboxTest

	self spawn: ListboxTest new.!

dateTest

	self spawn: DateTest new.!

buttonTest

	self spawn: ButtonTest new.!

showFreeMemory

	| stream |

	stream := String new writeStream.

	stream

		nextPutAll: 'ST: ';

		print: Smalltalk freeMemory;

		nextPut: $/;

		print: ##heapSize * 2;

		cr;

		nextPutAll: 'PalmOS: ';

		print: PalmOS freeMemory;

		nextPut: $/;

		print: PalmOS dynamicMemory.

	Form notify: stream contents.!

about
	Form dialog: 2100.
!

done

	Form notify: 'Thanks for trying the demo!!'.
	self class eventuallyExitSmalltalk.! !


!TestLauncher class methodsFor: 'accessing'!

formID

	^3000.! !


!Smalltalk class methodsFor: 'startup'!

start

	TestLauncher show.! !


